#include <bits/stdc++.h>

#include <ext/pb_ds/assoc_container.hpp>
#include <ext/pb_ds/tree_policy.hpp>

using namespace std;
using namespace __gnu_pbds;

#define int long long
#define sz(x) ((int) (x).size())
#define all(a) (a).begin(), (a).end()
#define rall(a) (a).begin(), (a).end()
#define ff first
#define ss second

using pii = pair<int, int>;

template<typename T, typename Cmp = less<T>>
using ordered_set =
        tree<T, null_type, Cmp, rb_tree_tag, tree_order_statistics_node_update>;

template<typename T>
void mnr(T &a, const T &b) {
    if (b < a) a = b;
}
template<typename T>
void mxr(T &a, const T &b) {
    if (b > a) a = b;
}

struct Vec {
    int x{}, y{};

    Vec() = default;
    Vec(int x, int y) : x(x), y(y) { }
    Vec(Vec a, Vec b) : x(b.x - a.x), y(b.y - a.y) { }

    long long operator%(const Vec& b) const {
        return 1ll * x * b.y - 1ll * y * b.x;
    }

    long long operator*(const Vec& b) const {
        return 1ll * x * b.x + 1ll * y * b.y;
    }

    friend istream& operator>>(istream& is, Vec& a) {
        return is >> a.x >> a.y;
    }
};

bool box(Vec p, Vec a, Vec b) {
    return p.x >= min(a.x, b.x) && p.x <= max(a.x, b.x) &&
           p.y >= min(a.y, b.y) && p.y <= max(a.y, b.y);
}

bool onseg(Vec p, Vec a, Vec b) {
    return Vec(a, p) % Vec(a, b) == 0 && box(p, a, b);
}

int sign(long long a) {
    if (a > 0) {
        return 1;
    }
    if (a < 0) {
        return -1;
    }
    return 0;
}

bool intersect(Vec a, Vec b, Vec c, Vec d) {
    if (onseg(a, c, d) || onseg(b, c, d) ||
        onseg(c, a, b) || onseg(d, a, b)) {
        return true;
    }
    Vec ab(a, b);
    Vec cd(c, d);
    return sign(ab % Vec(a, c)) * sign(ab % Vec(a, d)) < 0 &&
           sign(cd % Vec(c, a)) * sign(cd % Vec(c, b)) < 0;
}

struct Seg {
    Vec a{}, b{};
};

struct DSU {
private:
    vector <int> p, r;

public:
    int comp;
    explicit DSU(int n) : p(n), r(n), comp(n) {
        iota(all(p), 0);
    }

    int get(int a) {
        return (a == p[a] ? a : p[a] = get(p[a]));
    }

    void unite(int a, int b) {
        a = get(a), b = get(b);
        if (a == b) {
            return;
        }
        --comp;
        if (r[a] > r[b]) {
            swap(a, b);
        }
        p[a] = b;
        r[b] += (r[a] == r[b]);
    }
};

void solve() {
//        Vec a, b, c, d;
//        cin >> a >> b >> c >> d;
//        cout << intersect(a, b, c, d) << "\n";
//        return;
    int n;
    cin >> n;
    vector <Seg> v(n);
    for (auto& [a, b] : v) {
        cin >> a >> b;
    }
    int ver = 0, edg = 0;
    DSU dsu(n);
    for (int i = 0; i < n; ++i) {
        auto [a, b] = v[i];
        int pr = 0;
        int f1 = 1, f2 = 1;
        for (int j = 0; j < n; ++j) {
            if (i == j) {
                continue ;
            }
            if (onseg(a, v[j].a, v[j].b)) {
                f1 = 0;
            }
            if (onseg(b, v[j].a, v[j].b)) {
                f2 = 0;
            }
        }
        ver += f1 + f2;
        for (int j = i + 1; j < n; ++j) {
            auto [c, d] = v[j];
            if (intersect(a, b, c, d)) {
                dsu.unite(i, j);
                ++ver;
                ++pr;
            }
        }
        for (int j = 0; j < i; ++j) {
            auto [c, d] = v[j];
            if (intersect(a, b, c, d)) {
                ++pr;
            }
        }
        //        cerr << i << ": " << pr << "\n";
        edg += 1 + pr - !f1 - !f2;
    }
    //ver - edg + ans = 2
    //ans = 2 - (ver - edg)
    cout << 2 - (ver - edg) + (dsu.comp - 1) << "\n";
}

signed main() {
    ios_base::sync_with_stdio(false);
#ifdef SYSTY257
    freopen("inputik.txt", "r", stdin);
    freopen("outputik.txt", "w", stdout);
#else
    cin.tie(nullptr);
#endif
    int t;
    cin >> t;
    while (t--) {
        solve();
    }
}
